import os
from flask import Flask, request, jsonify

app = Flask(__name__)

# --- Clave Secreta para seguridad (¡MANTENER ESTO!) ---
ZENDER_WEBHOOK_SECRET = os.environ.get("ZENDER_WEBHOOK_SECRET", "tu_clave_secreta_por_defecto_si_no_existe_variable_entorno")

# --- Función para generar respuestas dinámicas (MODIFICADA) ---
def generate_service_response(inquiry_type=None):
    """
    Genera una respuesta sobre TODOS los servicios de Cobol Ingeniería SAS
    basada en el tipo de consulta, incluyendo la lógica de briefing.
    """
    # Información base y de contacto
    base_info = "En Cobol Ingeniería SAS ofrecemos soluciones digitales de alta calidad para impulsar tu negocio. Nos enfocamos en la excelencia y el soporte continuo."
    contact_info = "\nPuedes encontrar más detalles y contactarnos directamente en nuestra web: https://cobol.com.co/contacto"
    
    # 1. Normalizar y verificar el inquiry_type
    if inquiry_type:
        inquiry_type = inquiry_type.lower().replace(" ", "_").strip()

    # 2. Lógica de BRIEFING para Desarrollo (NUEVO)
    if inquiry_type in ["desarrollo_web", "desarrollo_app"]:
        # Se activa el proceso de cualificación/briefing
        brief_type = "sitio web" if inquiry_type == "desarrollo_web" else "aplicación móvil/web"
        
        brief_response = (
            f"¡Perfecto! Estoy aquí para ayudarte a iniciar tu proyecto de **{brief_type}**. "
            "Para ofrecerte una cotización precisa y entender a fondo tus necesidades, por favor, ayúdame respondiendo estas preguntas clave:\n\n"
            "1. - ¿Cuál es el objetivo principal del proyecto? (Ventas, información, herramienta interna, etc.)\n"
            "2. - ¿Tiene un diseño o estructura ya definidos? (¿Necesita diseño desde cero o ya tiene uno?)\n"
            "3. - ¿Qué funcionalidades especiales necesita? (Pasarelas de pago, base de datos, inicio de sesión de usuarios, etc.)\n"
            "4. - ¿Tiene un presupuesto o plazo de entrega en mente?\n\n"
            "Con esta información, podemos preparar la mejor propuesta para usted."
        )
        return f"{base_info} {brief_response}" # NO incluir contact_info aquí, el brief es la prioridad

    # 3. Respuestas para Servicios de Infraestructura/Otros (AMPLIADO)
    responses = {
        "hosting_compartido": (
            "Nuestro servicio de **Hosting Compartido** es robusto y seguro, con servidores de alto rendimiento que incluyen **CloudLinux** y **cPanel**. "
            "Garantizamos alta disponibilidad, seguridad y te ofrecemos un dominio gratuito por un año."
        ),
        "dominios": (
            "Gestionamos el **registro de dominios** de forma rápida y sencilla (.com, .co, .net, etc.), asegurando que tu marca esté protegida en línea."
        ),
        "servidores_vps": (
            "Ofrecemos **Servidores VPS** (Virtual Private Server) para quienes necesitan más control y recursos que el hosting compartido. "
            "Son ideales para proyectos de alto tráfico o aplicaciones específicas, con escalabilidad garantizada."
        ),
        "servidores_dedicados": (
            "Nuestros **Servidores Dedicados** te dan el máximo rendimiento y control. Tienes un servidor físico solo para ti, "
            "perfecto para aplicaciones críticas, grandes volúmenes de datos o tráfico masivo."
        ),
        "soporte_tecnico": (
            "Proporcionamos **soporte técnico** continuo y especializado para todos nuestros servicios (web, hosting, apps). "
            "Nuestro equipo está listo para ayudarte con cualquier incidencia o consulta, garantizando la continuidad de tu negocio."
        ),
        # Respuesta general (Default) - (ACTUALIZADA)
        "general": (
            "Ofrecemos una suite completa de soluciones: **desarrollo web y apps**, **hosting compartido**, **servidores VPS/dedicados** y **registro de dominios**. "
            "Todas nuestras soluciones se centran en la calidad, el soporte y la seguridad. ¿Te gustaría saber más sobre un servicio específico?"
        )
    }

    # Seleccionar la respuesta más adecuada
    response_text = responses.get(inquiry_type, responses["general"])

    return f"{base_info} {response_text} {contact_info}"

# --- Endpoint para el Webhook de Zender (MODIFICADO) ---
# CRÍTICO: Escucha en ambas rutas para cubrir todos los escenarios de reescritura del proxy.
@app.route('/', methods=['POST'])
@app.route('/zender-webhook', methods=['POST']) 
def zender_webhook():
    # ... (Verificación de seguridad se mantiene igual) ...

    try:
        data = request.get_json()
        app.logger.info(f"Datos recibidos de Zender: {data}")

        function_call = data.get('call', {})
        function_name = function_call.get('name')
        function_args = function_call.get('args', {})

        # ¡CAMBIAR NOMBRE DE FUNCIÓN AQUÍ!
        if function_name == "getServiceInfo": 
            inquiry_type = function_args.get("inquiry_type")
            response_message = generate_service_response(inquiry_type)
            
            # Formato de respuesta {"fulfillmentText": "..."}
            return jsonify({
                "fulfillmentText": response_message
            })
        else:
            app.logger.warning(f"Función no reconocida: {function_name}")
            return jsonify({"fulfillmentText": "Lo siento, no puedo procesar esa solicitud."}), 400

    except Exception as e:
        app.logger.error(f"Error procesando la solicitud del webhook: {e}", exc_info=True)
        return jsonify({"fulfillmentText": "Hubo un error al procesar tu solicitud. Por favor, inténtalo de nuevo más tarde."}), 500

# --- Inicio del Servidor Flask (Se mantiene igual) ---
if __name__ == '__main__':
    print("¡Advertencia! Este script solo está configurado para desarrollo.")
    print("Para producción, usa un servidor WSGI (ej. Gunicorn).")
    print("Para ejecutar en desarrollo: FLASK_APP=app.py flask run --port 5000")